{

    Unit CovernatorMainUnit

    - Hauptunit des Covernators

    ---------------------------------------------------------------
    Covernator
    Copyright (C) 2010, Daniel Gaussmann
    http://www.gausi.de
    mail@gausi.de
    ---------------------------------------------------------------
    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
    or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA 02110, USA
    ---------------------------------------------------------------
}

unit CovernatorMainUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ExtCtrls, fldbrows, StdCtrls, ContNrs,
  AudioFileClass, CoverDownloads, ExtDlgs, Jpeg, filetypes,
  Mp3FileUtils, ID3v2Frames, Menus;


type
  TMainForm = class(TForm)
    StatusBar1: TStatusBar;
    MainPanel: TPanel;
    CoverSaveDialog: TSaveDialog;
    SearchCoverDlg: TOpenPictureDialog;
    Panel1: TPanel;
    LVAudioFiles: TListView;
    GroupBox1: TGroupBox;
    EditCurrentDir: TLabeledEdit;
    BtnSelectDirectory: TButton;
    GroupBox2: TGroupBox;
    Lbl_FoundCovers: TLabel;
    BtnDownloadCover: TButton;
    BtnSearchCover: TButton;
    cbFoundCovers: TComboBox;
    CoverImage: TImage;
    GroupBox3: TGroupBox;
    cbCoverSize: TComboBox;
    lblCoverSize: TLabel;
    PnlInfo: TPanel;
    BtnCovernate: TButton;
    LblCoverDimensions: TLabel;
    GroupBox4: TGroupBox;
    Id3TagImage: TImage;
    cbExistingPictures: TComboBox;
    BtnExCovernate: TButton;
    cbOnlySelected: TCheckBox;
    MainMenu1: TMainMenu;
    MM_Datei: TMenuItem;
    MM_Install: TMenuItem;
    MM_Uninstall: TMenuItem;
    MM_Extra: TMenuItem;
    MM_PlaylistCreate: TMenuItem;
    MM_About: TMenuItem;
    PlaylistSaveDlg: TSaveDialog;
    procedure BtnSelectDirectoryClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure BtnDownloadCoverClick(Sender: TObject);
    procedure cbFoundCoversChange(Sender: TObject);
    procedure BtnSearchCoverClick(Sender: TObject);
    procedure LVAudioFilesKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure cbExistingPicturesChange(Sender: TObject);
    procedure BtnCovernateClick(Sender: TObject);
    procedure LVAudioFilesSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure BtnExCovernateClick(Sender: TObject);
    procedure MM_InstallClick(Sender: TObject);
    procedure MM_UninstallClick(Sender: TObject);
    procedure MM_AboutClick(Sender: TObject);
    procedure MM_PlaylistCreateClick(Sender: TObject);
  private
    { Private-Deklarationen }
    AudioFileList: TObjectList;
    CoverPaths: TStringList;
    currentDir: String;

    id3Tag: TID3v2Tag;
    CurrentPicFrames: TObjectList;


  public
    { Public-Deklarationen }
    procedure CollectMP3Files(aDirectory: String);
    procedure FillListView;
    procedure DoIt(aDir: String);

    procedure ShowCoverSize;

    procedure OnCoverDownloaderXMLComplete(Sender: TCoverDownloader; Status: String);
    procedure OnCoverDownloaderCoverURLFound(Sender: TCoverDownloader; Status: String);
    procedure OnCoverDownloaderError(Sender: TCoverDownloader; Status: String);
    procedure OnCoverDownloaderBeforeSave(Sender: TCoverDownloader; PicType: TPicType; var Filename: String);

// TCoverDownloaderStatusEvent = procedure(Sender: TCoverDownloader; Status: String) of Object;
// TCoverDownloaderBeforeSaveEvent = procedure(Sender: TCoverDownloader; PicType: TPicType; var SaveDir: String) of Object;


  end;


  //function IsProperAlbum(aAudioFileList: TObjectList): Boolean;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

uses CoverHelper, AboutForm, StrUtils;


procedure TMainForm.FormCreate(Sender: TObject);
begin
    AudioFileList := TObjectList.Create;
    CoverPaths := TStringList.Create;

    id3Tag := TID3v2Tag.Create;
    CurrentPicFrames := Nil
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
    AudioFileList.Free;
    CoverPaths.Free;
    if assigned(CurrentPicFrames) then
        CurrentPicFrames.Free;

    id3Tag.Free;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
    if ParamCount > 0 then
    begin
        DoIt(ParamStr(1));
        caption := ParamStr(1);
    end;
end;

procedure TMainForm.LVAudioFilesSelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
var
    af: TAudioFile;
    stream: TMemoryStream;
    mime: AnsiString;
    PicType: Byte;
    Description: UnicodeString;
    i: Integer;
begin
    if Selected then
    begin
        af := TAudioFile(Item.Data);

        id3Tag.ReadFromFile(af.Path);

        if assigned(CurrentPicFrames) then
            FreeAndNil(CurrentPicFrames);
        CurrentPicFrames := id3Tag.GetAllPictureFrames;
        cbExistingPictures.Items.Clear;
        stream := TMemoryStream.Create;
        try
            for i := CurrentPicFrames.Count - 1 downto 0 do // andersrum, damit das erste Bild am Ende im Speicher ist. ;-)
            begin
                Stream.Clear;
                (CurrentPicFrames[i] as TID3v2Frame).GetPicture(Mime, PicType, Description, stream);
                if PicType < length(Picture_Types) then
                    cbExistingPictures.Items.Insert(0, Format('[%s] %s', [Picture_Types[PicType], Description]))
                else
                    cbExistingPictures.Items.Insert(0, Format('[%s] %s', [Picture_Types[0], Description]));
            end;
            if cbExistingPictures.Items.Count > 0 then
            begin
                cbExistingPictures.ItemIndex := 0;
                Id3TagImage.Visible := True;
                stream.Seek(0, soFromBeginning);
                PicStreamToImage(stream, Mime, Id3TagImage.Picture.Bitmap);
            end else
            begin
                cbExistingPictures.ItemIndex := -1;
                Id3TagImage.Picture.Assign(NIL);
                Id3TagImage.Visible := False;
            end;
        finally
            stream.Free;
        end;

    end;

end;

procedure TMainForm.MM_InstallClick(Sender: TObject);
var ftr: TFileTypeRegistration;
begin
    if MessageDlg('Der Covernator fgt jetzt dem Kontextmen der Ordner im Windows Explorer die Option "Covernate" hinzu.', mtInformation, [mbOk, mbAbort], 0 ) = mrOK then
    begin
        ftr := TFileTypeRegistration.Create;
        try
            ftr.AddDirectoryHandler('Covernate','"' +  Paramstr(0) + '" "%1"', 'Im Covernator ffnen');
        finally
            ftr.free;
        end;
    end;
end;


procedure TMainForm.MM_UninstallClick(Sender: TObject);
var ftr: TFileTypeRegistration;
begin
    if MessageDlg('Der Covernator wird den Eintrag "Covernate" im Windows-Exlporer wieder entfernen.', mtInformation, [mbOk, mbAbort], 0 ) = mrOK then
    begin
        ftr := TFileTypeRegistration.Create;
        try
            ftr.DeleteDirectoryHandler('Covernate');
        finally
            ftr.free;
        end;
    end;
end;


procedure TMainForm.MM_PlaylistCreateClick(Sender: TObject);
var
  myAList: tStringlist;
  i: integer;
  aAudiofile: TAudioFile;
  aFilename: String;

        function ExtractRelativePathNew(const BaseName, DestName: UnicodeString): UnicodeString;
        var
          BasePath, DestPath: UnicodeString;

          function ExtractFilePathNoDrive(const FileName: UnicodeString): UnicodeString;
          begin
              Result := ExtractFilePath(FileName);
              Delete(Result, 1, Length(ExtractFileDrive(FileName)));
          end;

        begin
          if AnsiSameText(ExtractFileDrive(BaseName), ExtractFileDrive(DestName)) then
          begin
              // Beide Dateien auf demselben Laufwerk
              BasePath := ExtractFilePathNoDrive(BaseName); // Pfade inkl. \
              DestPath := ExtractFilePathNoDrive(DestName); // Pfad inkl. \

              if AnsiStartsStr(BasePath, DestPath) then
                  result := ExtractRelativePath(BaseName, DestName)
              else
                  result := DestPath + ExtractFileName(DestName);
          end
          else
              Result := DestName;
        end;


begin
    PlaylistSaveDlg.InitialDir := currentDir;
    if AudioFileList.Count > 0 then
        PlaylistSaveDlg.FileName := TAudioFile(AudioFileList[0]).Artist + ' - ' + TAudioFile(AudioFileList[0]).Title
    else
        PlaylistSaveDlg.FileName := '';

    if PlaylistSaveDlg.Execute then
    begin
        aFilename := PlaylistSaveDlg.FileName;

        if (AnsiLowerCase(ExtractFileExt(aFilename)) = '.m3u')
           or (AnsiLowerCase(ExtractFileExt(aFilename)) = '.m3u8') then
        begin
            // Mit Delphi 2009 ist das alles gleich, bis auf die Kodierung am Ende
            myAList := TStringList.Create;
            try
                myAList.Add('#EXTM3U');

                for i := 0 to AudioFileList.Count - 1 do
                begin
                    aAudiofile := AudioFileList[i] as TAudioFile;
                        myAList.add('#EXTINF:' + IntTostr(aAudiofile.Duration) + ','
                            + aAudioFile.Artist + ' - ' + aAudioFile.Title);
                        myAList.Add(ExtractRelativePathNew(aFilename, aAudioFile.Path ));
                end;
                try
                    if (AnsiLowerCase(ExtractFileExt(aFilename)) = '.m3u') then
                        myAList.SaveToFile(aFilename, TEncoding.Default)
                    else
                        myAList.SaveToFile(aFilename, TEncoding.UTF8);
                except
                    on E: Exception do
                        MessageDLG(E.Message, mtError, [mbOK], 0);
                end;
            finally
                FreeAndNil(myAList);
            end;
        end
    end;
end;


procedure TMainForm.cbExistingPicturesChange(Sender: TObject);
var stream: TMemorystream;
    mime: AnsiString;
    PicType: Byte;
    Description: UnicodeString;
begin
    stream := TMemoryStream.Create;
    try
        ID3TagImage.Visible := True;
        (CurrentPicFrames[cbExistingPictures.ItemIndex] as TID3v2Frame).GetPicture(Mime, PicType, Description, stream);
        PicStreamToImage(stream, Mime, ID3TagImage.Picture.Bitmap);
    finally
        stream.Free;
    end;
end;


procedure TMainForm.LVAudioFilesKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var x: Integer;
begin
    case Key of
        VK_Delete: begin
            x := LVAudioFiles.ItemIndex;
            if x >= 0 then
            begin
                LVAudioFiles.Items.Delete(x);
                AudioFileList.Delete(x);
            end;
        end;
    end;
end;


procedure TMainForm.BtnSelectDirectoryClick(Sender: TObject);
var FB: TFolderBrowser;
begin
    FB := TFolderBrowser.Create(self.Handle, 'Verzeichnis auswhlen', EditCurrentDir.Text );
    try
        if FB.Execute then
            // DateiSuche starten
            DoIt(FB.SelectedItem);
    finally
        fb.Free;
    end;
end;


procedure TMainForm.BtnSearchCoverClick(Sender: TObject);
begin
    SearchCoverDlg.InitialDir := currentDir;
    if SearchCoverDlg.Execute then
    begin
        CoverPaths.Add(SearchCoverDlg.FileName);
        cbFoundCovers.Items.Add(ExtractFilename(SearchCoverDlg.FileName));
        cbFoundCovers.ItemIndex := cbFoundCovers.Items.Count - 1;
        CoverImage.Picture.LoadFromFile(CoverPaths[cbFoundCovers.ItemIndex]);
        CoverImage.Visible := True;
        ShowCoverSize;
    end;
end;


procedure TMainForm.OnCoverDownloaderBeforeSave(Sender: TCoverDownloader;
  PicType: TPicType; var Filename: String);
begin
    Statusbar1.Panels[0].Text := 'Cover geladen. Speichere ...';
    CoverSaveDialog.InitialDir := ExtractFilePath(Filename);
    CoverSaveDialog.FileName := ExtractFileName(Filename);

    case PicType of
        ptJPG:  begin
              CoverSaveDialog.Filter := 'Jpeg-Bilder|*.jpg';
              CoverSaveDialog.DefaultExt := 'jpg';
        end;
        ptPNG: begin
              CoverSaveDialog.Filter := 'PNG-Bilder|*.png';
              CoverSaveDialog.DefaultExt := 'png';
        end
    end;
    if CoverSaveDialog.Execute then
        Filename := CoverSaveDialog.FileName
    else
        Filename := '';
end;
procedure TMainForm.OnCoverDownloaderCoverURLFound(Sender: TCoverDownloader;
  Status: String);
begin
    Statusbar1.Panels[0].Text := Status;
    Statusbar1.Update;
end;
procedure TMainForm.OnCoverDownloaderXMLComplete(Sender: TCoverDownloader;
  Status: String);
begin
    Statusbar1.Panels[0].Text := Status;
    Statusbar1.Update;
end;
procedure TMainForm.OnCoverDownloaderError(Sender: TCoverDownloader;
  Status: String);
begin
    MessageDlg(Status, mtWarning, [mbOk], 0 );
    Statusbar1.Panels[0].Text := '';
    Statusbar1.Update;
end;

procedure TMainForm.ShowCoverSize;
var pic: TPicture;
begin
    pic := tPicture.Create;
    try

        if (cbFoundCovers.ItemIndex >= 0) and FileExists(CoverPaths[cbFoundCovers.ItemIndex]) then
        begin
            pic.LoadFromFile(CoverPaths[cbFoundCovers.ItemIndex]);
            LblCoverDimensions.Caption := 'Gre des gewhlten Bildes: '
                   + inttostr(pic.Width) + 'x' + inttostr(pic.Height);
       end
       else
            LblCoverDimensions.Caption := '';
    finally
        pic.Free;
    end;
end;


procedure TMainForm.cbFoundCoversChange(Sender: TObject);
begin
    if FileExists(CoverPaths[cbFoundCovers.ItemIndex]) then
        CoverImage.Picture.LoadFromFile(CoverPaths[cbFoundCovers.ItemIndex])
    else
        MessageDlg('Ups, die Datei ist nicht mehr da...', mtError, [mbOk], 0 );

    ShowCoverSize;
end;

procedure TMainForm.DoIt(aDir: String);
var i, front: Integer;
begin
    aDir := IncludeTrailingPathDelimiter(aDir);
    EditCurrentDir.Text := aDir;
    currentDir := aDir;
    CollectMP3Files(aDir);
    FillListView;

    CoverPaths.Clear;
    cbFoundCovers.Clear;

    SucheCover(aDir, CoverPaths);
    for i := 0 to CoverPaths.Count - 1 do
        cbFoundCovers.Items.Add(ExtractFilename(CoverPaths[i]));

    front := GetFrontCover(CoverPaths);
    if front >= 0 then
    begin
        cbFoundCovers.ItemIndex := front;
        CoverImage.Picture.LoadFromFile(CoverPaths[front]);
    end;

    CoverImage.Visible := front >= 0;
    ShowCoverSize;
end;


procedure TMainForm.CollectMP3Files(aDirectory: String);
var sr : TSearchrec;
    c: Integer;
    newFile: TAudioFile;
begin
    c := 0;
    AudioFileList.Clear;

    if Findfirst(aDirectory + '*.mp3', FaAnyfile, sr) = 0 then
    repeat
        inc(c);
        if (sr.name<>'.') AND (sr.name<>'..') then
        begin
            newFile := TAudioFile.create;
            newFile.GetAudioData(aDirectory + sr.Name);
            AudioFileList.Add(NewFile);
        end;
    until (Findnext(sr) <> 0) or (c > 100);
    Findclose(sr);
end;



procedure TMainForm.FillListView;
var newItem: TListItem;
    i, t: Integer;
    af: TAudioFile;
begin
    LVAudioFiles.Clear;
    for i := 0 to AudioFileList.Count-1 do
    begin
        af := TAudiofile(AudioFileList[i]);
        newItem := LVAudioFiles.Items.Add;

        newItem.Caption := af.Artist;
        NewItem.SubItems.Add(af.Title);
        NewItem.SubItems.Add(af.Album);
        NewItem.SubItems.Add(af.Filename);
        t := af.Duration;
        NewItem.SubItems.Add(Format('%d:%.2d',[t Div 60, t Mod 60]));
        NewItem.Data := af;
    end;
end;





procedure TMainForm.MM_AboutClick(Sender: TObject);
begin
    About.Show;
end;

procedure TMainForm.BtnCovernateClick(Sender: TObject);
var i: Integer;
    af: tAudioFile;
    mime: AnsiString;
    PicData: TMemoryStream;
    sourceGraphic: TPicture;
    dim: Integer;
begin
    if cbFoundCovers.Items.Count > 0 then
    begin
        if AnsiLowercase(ExtractFileExt(CoverPaths[cbFoundCovers.ItemIndex])) = '.png' then
            mime := 'image/png'
        else
            if AnsiLowercase(ExtractFileExt(CoverPaths[cbFoundCovers.ItemIndex])) = '.jpg' then
                mime := 'image/jpg'
            else
                mime := '';

        // PicData enthlt am Ende PNG oder Jpeg-Daten, je nach dem ob das Cover ein PNG oder ein anderes Format hat
        PicData := TMemoryStream.Create;
        try
            if cbCoverSize.ItemIndex = 0 then
                // Bild in Originalgre nehmen, was anderes auer png und jpeg wird nach jpeg konvertiert
                LoadGraphicIntoPicStream(CoverPaths[cbFoundCovers.ItemIndex], mime, PicData)
            else
            begin
                // Bild verkleinert speichern
                case cbCoverSize.ItemIndex of
                    1: dim := 300;
                    2: dim := 240;
                    3: dim := 128;
                    4: dim := 64;
                else
                     dim := 128;
                end;
                sourceGraphic := TPicture.Create;
                try
                    sourceGraphic.LoadFromFile(CoverPaths[cbFoundCovers.ItemIndex]);
                    if (sourceGraphic.Width > dim) and (sourceGraphic.Height > dim) then
                        // hinweis: mime='' erzeugt da drin ein jpeg
                        ResizeGraphicToStream(sourceGraphic.Graphic, mime, PicData, dim, dim)
                    else
                        // orignal nehmen, nicht knstlich vergrern.
                        // was anderes auer png und jpeg wird nach jpeg konvertiert
                        LoadGraphicIntoPicStream(CoverPaths[cbFoundCovers.ItemIndex], mime, PicData);
                finally
                    sourceGraphic.Free;
                end;
            end;

            // "Andere" Bildformate wurden nach Jpeg kobvertiert - mime jetzt ndern
            if mime = '' then
                mime := 'image/jpg';

            for i := 0 to AudioFileList.Count - 1 do
            begin
                if (not cbOnlySelected.Checked) or (LVAudioFiles.Items[i].Selected) then
                begin
                    af := TAudioFile(AudioFileList[i]);
                    af.Covernate(mime, PicData);
                end;
            end;
            if LVAudioFiles.Items.Count > 0 then
                LVAudioFiles.Selected := LVAudioFiles.Items[0];
        finally
            PicData.Free;
        end;
    end else
        MessageDlg('Bitte erst ein Cover auswhlen', mtWarning, [mbOk], 0 );
end;


procedure TMainForm.BtnExCovernateClick(Sender: TObject);
var i: Integer;
    af: TAudioFile;
begin
    for i := 0 to AudioFileList.Count - 1 do
    begin
        if (not cbOnlySelected.Checked) or (LVAudioFiles.Items[i].Selected) then
        begin
            af := TAudioFile(AudioFileList[i]);
            af.ExCovernate;
        end;
    end;
    if LVAudioFiles.Items.Count > 0 then
        LVAudioFiles.Selected := LVAudioFiles.Items[0];
end;

procedure TMainForm.BtnDownloadCoverClick(Sender: TObject);
var Downloader: TCoverDownloader;
    aArtist, aAlbum: String;
begin
    Downloader := TCoverDownloader.Create;
    try
        Downloader.OnXMLComplete     :=  OnCoverDownloaderXMLComplete     ;
        Downloader.OnCoverURLFound   :=  OnCoverDownloaderCoverURLFound   ;
        Downloader.OnError           :=  OnCoverDownloaderError           ;
        Downloader.OnBeforeSave      :=  OnCoverDownloaderBeforeSave      ;

        GetCoverInfos(AudioFileList, aArtist, aAlbum);
        if (aAlbum <> 'Unknown compilation')
            and (aArtist <> AUDIOFILE_UNKOWN)
            and (aAlbum <> AUDIOFILE_UNKOWN)
        then
        begin
            if Downloader.DownloadCover(aArtist, aAlbum, currentDir) then
            begin
                CoverPaths.Add(Downloader.SavedFile);
                cbFoundCovers.Items.Add(ExtractFilename(Downloader.SavedFile));
                cbFoundCovers.ItemIndex := cbFoundCovers.Items.Count - 1;
                CoverImage.Picture.LoadFromFile(CoverPaths[cbFoundCovers.ItemIndex]);
                CoverImage.Visible := True;
            end;
        end
        else
            MessageDlg('Sorry, aber das sieht nicht nach einem richtigem Album aus...', mtInformation, [mbOk], 0 );

        ShowCoverSize;
    finally
        Statusbar1.Panels[0].Text := '';
        Downloader.Free;
    end;
end;





end.
